///////////////////////////////////////////////////////////////////////////////
//
//  File:    joyx.cpp
//
//  Class:   JoystickUnixX
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The JoystickUnixX class encapsulates joystick access for the Unix/X
//      platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "joyx.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: s_build
//
//  Description:
//
//      This is a factory method to create a Unix/X Joystick object.
//
//  Parameters:
//
//      iName (input)
//          The name of the object.
//
//  Returns:
//
//      A pointer to the new object.
//
///////////////////////////////////////////////////////////////////////////////
JoystickUnixX*
JoystickUnixX::s_build(
    const KString& iName
)
{
    //  Create the new object.
    JoystickUnixX* pThis = new JoystickUnixX( iName );

    //  Initialize the new object.
    pThis->init( );

    //  Send back the new joystick.
    return( pThis );
}




///////////////////////////////////////////////////////////////////////////////
//
//  Function: JoystickUnixX
//
//  Description:
//
//      This is the main constructor for the Unix/X Joystick object.  This is
//      a protected member.  Clients wishing to create a joystick object should
//      do so through the factory method.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
JoystickUnixX::JoystickUnixX(
    const KString&  iName
)
:
    Joystick ( iName )
{
    //  All initialization is done in init( ).
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: init
//
//  Description:
//
//      This is called to initialize the joystick object.  By using an init
//      member we get access to virtual functions that we wouldn't in the
//      constructor.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
JoystickUnixX::init(
)
{
    //  Call the base class.
    Joystick::init( );

    //  We don't yet have generic joystick support for Unix/X so disable
    //  the joystick.
    m_bEnabled = FALSE;
}




///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~JoystickUnixX
//
//  Description:
//
//      This is the destructor for a Unix/X joystick object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
JoystickUnixX::~JoystickUnixX(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the joystick object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
JoystickUnixX::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "JoystickUnixX" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: update
//
//  Description:
//
//      This member should be called periodically to allow the
//      joystick object to update itself.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      TRUE  if a joystick state has changed.
//      FALSE if no joystick state has changed.
//
///////////////////////////////////////////////////////////////////////////////
Byte
JoystickUnixX::update(
)
{
    return( FALSE );
}
