///////////////////////////////////////////////////////////////////////////////
//
//  File:       mousex.h
//
//  Class:      MouseUnixX - Concrete
//  
//  Hierarchy:  MouseUnixX - Mouse - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The MouseUnixX class encapsulates mouse access for the Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _mousex_h_
#define _mousex_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "mouse.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  MouseUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class MouseUnixX : public Mouse
{
    public:

        //  Build method.
        static MouseUnixX* s_build( const KString& iName );

        //  Deletion.
        virtual ~MouseUnixX ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
        virtual Byte           update       ( );

    protected:

        //  Creation is protected.  Clients should use a build method.
        MouseUnixX ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );

    private:

};

#endif
