///////////////////////////////////////////////////////////////////////////////
//
//  File:       networkx.h
//
//  Class:      NetworkUnixX - Concrete
//  
//  Hierarchy:  NetworkUnixX - Network - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The NetworkUnixX class implements a tcp/ip connection between 2
//      or more Replay processes.  
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _networkx_h_
#define _networkx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <X11/Xlib.h>

//  Application Headers.
#include "network.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  NetworkUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class NetworkUnixX : public Network
{
    public:

        //  Creation/Deletion.
                 NetworkUnixX ( const KString& iName );
        virtual ~NetworkUnixX ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Connection.
        virtual Byte openNetwork     ( ConnectType eType );
        virtual Byte acceptClient    ( );
        virtual Byte connectToServer ( );
        virtual void closeNetwork    ( );
        virtual void closeConnection ( DWord dwConnection );

        //  Message passing.
        virtual void readMsg  ( const DWord dwConnection, Msg* pMsg );
        virtual void writeMsg ( const DWord dwConnection, Msg* pMsg );


    protected:

        //  The possible pending events.
        typedef enum
        {
            READ,
            WRITE,
            EXCEPTION
        }
        PendingEvent;

        //  Utility.
        Byte isPending ( PendingEvent eEvent, int nSockFD );

        //  Member Data.
        struct sockaddr_in m_serverAddress;
        int                m_nSockFD;
        int*               m_pConnectFDList;
        Display*           m_pDisplay;

        //  Static Member Data.
        static int sm_nDefaultPort;

    private:

};

#endif
