///////////////////////////////////////////////////////////////////////////////
//
//  File:       pagex.h
//
//  Class:      PageUnixX - Concrete
//  
//  Hierarchy:  PageUnixX - Page - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a window of the Replay application on
//      the Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _pagex_h_
#define _pagex_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  X Headers.
#include <X11/Xlib.h>

//  Application Headers.
#include "page.h"


///////////////////////////////////////////////////////////////////////////////
//  PageUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class PageUnixX : public Page
{
    public:

        //  Creation/Deletion.
        PageUnixX ( 
            const KString& iName, 
            const DWord    dwWidth, 
            const DWord    dwHeight,
            const Byte     bTransposed,
            Display*       pDisplay,
            Screen*        pScreen,
            Colormap       colourMap
        );
        virtual ~PageUnixX ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void transpose ( );

        //  Unix/X specific access.
        Window   getWindow    ( ) const;

    protected:

        //  Member Data.
        Window   m_window;
        Display* m_pDisplay;
        Screen*  m_pScreen;
        
    private:

};


///////////////////////////////////////////////////////////////////////////////
//  PageUnixX Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Window
PageUnixX::getWindow(
) const
{
    return( m_window );
}

#endif
