//////////////////////////////////////////////////////////////////////////////
//
//  File:    soundx.cpp
//
//  Class:   SoundUnixX
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The SoundSolaris class is a class encapsulating sound on the Unix/X
//      platform.  Currently there is generic sound support for Unix/X
//      platforms.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "soundx.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: SoundUnixX
//
//  Description:
//
//      This is the main constructor for a Unix/X sound object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
SoundUnixX::SoundUnixX(
    const KString&  iName
)
:
    Sound            ( iName )
{
    //  Turn sound off.
    m_bEnabled = FALSE;
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~SoundUnixX
//
//  Description:
//
//      This is the destructor for a Unix/X sound object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
SoundUnixX::~SoundUnixX(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the sound object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
SoundUnixX::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "SoundUnixX" );

    return( className );
}




///////////////////////////////////////////////////////////////////////////////
//
//  Function: getNumChannels
//
//  Description:
//
//      This member is called to return the number of voice channels.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The number of voices.
//
///////////////////////////////////////////////////////////////////////////////
DWord
SoundUnixX::getNumChannels(
) const
{
    return( 0 );
}


///////////////////////////////////////////////////////////////////////////////
//
//  Function: update
//
//  Description:
//
//      This member is called to allow the sound system to update itself.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      FALSE.
//
///////////////////////////////////////////////////////////////////////////////
Byte
SoundUnixX::update(
)
{
    return( FALSE );
}


///////////////////////////////////////////////////////////////////////////////
//
//  Function: play
//
//  Description:
//
//      This member is called to play the specified sample.  It simply adds
//      the sample to a list that will be played during update().
//
//  Parameters:
//
//      pSample (input)
//          The sample to play.
//
//      bLoop (input)
//          The sample is to loop.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void 
SoundUnixX::play(
    Sample*    /* pSample is unused */,
    const Byte /* bLoop is unused */
)
{
}


///////////////////////////////////////////////////////////////////////////////
//
//  Function: playStreamed
//
//  Description:
//
//      This member is called to stream the specified sample.
//
//  Parameters:
//
//      pSample (input)
//          The sample to play.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void 
SoundUnixX::playStreamed(
    Sample* /* pSample is unused */
)
{
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: stop
//
//  Description:
//
//      This member is called to stop sample playback on the specified
//      channel.
//
//  Parameters:
//
//      dwChannel (input)
//          The channel to stop playback on.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void 
SoundUnixX::stop(
    const DWord /* dwChannel is unused */
)
{
} 
