///////////////////////////////////////////////////////////////////////////////
//
//  File:       bmp.h
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This header is used to define the prototypes for the ASM routines
//      contained in bmp.asm.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _bmp_h_
#define _bmp_h_

///////////////////////////////////////////////////////////////////////////////
//  Required Headers.
///////////////////////////////////////////////////////////////////////////////
#include "reptypes.h"

///////////////////////////////////////////////////////////////////////////////
//  Types.
///////////////////////////////////////////////////////////////////////////////
typedef struct
{
    Byte** DestStart;
    DWord  DestWidth;
    DWord  DestHeight;
    Byte** SrcStart;
    DWord  SrcWidth;
    DWord  SrcHeight;
    int32  DestX;
    int32  DestY;
    int32  ClipMinX;
    int32  ClipMaxX;
    int32  ClipMinY;
    int32  ClipMaxY;
    DWord  FlipX;
    DWord  FlipY;
    DWord* ColourTable;
    DWord  Transparency;
    DWord  TransparentColour;
    DWord  StartTime;
    DWord  EndTime;
}
BlitInfo;

///////////////////////////////////////////////////////////////////////////////
//  Prototypes.
///////////////////////////////////////////////////////////////////////////////
extern "C"
{
void bitmapBlitChar( );
void bitmapBlitSprite( );
void bitmapBlitScroll( );
void bitmapBlitScrollTransparent( );
}

///////////////////////////////////////////////////////////////////////////////
//  Exports.
///////////////////////////////////////////////////////////////////////////////
#ifdef UNIX
#define blitInfo _blitInfo
#endif
extern BlitInfo blitInfo;

#endif
