///////////////////////////////////////////////////////////////////////////////
//
//  File:    control.cpp
//
//  Class:   Controller
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The Controller class is an abstract base class representing any
//      controller object such as a joystick, keyboard, mouse, etc.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "control.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: Controller
//
//  Description:
//
//      This is the main constructor for a controller object.  It is protected
//      so that only derived classes have access to it.  Clients should
//      use a build method to create a controller object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Controller::Controller(
    const KString&  iName
)
:
    RepBase           ( iName ),
    m_bEnabled        ( TRUE )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: init
//
//  Description:
//
//      This is called from the build method to initialize the object.
//      It allows virtual methods to be called during construction.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
Controller::init(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~Controller
//
//  Description:
//
//      This is the destructor for a controller object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Controller::~Controller(
)
{
    //  Nothing to do.
}
