///////////////////////////////////////////////////////////////////////////////
//
//  File:    mouse.cpp
//
//  Class:   Mouse
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The Mouse class encapsulates mouse access.  This is an abstract
//      class that serves as a base for derived mouse classes for each
//      platform supported.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "mouse.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: Mouse
//
//  Description:
//
//      This is the main constructor for a mouse object.
//      It is protected so that only derived classes have access to it.
//      Clients should use a build method to create a mouse object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Mouse::Mouse(
    const KString&  iName
)
:
    Controller ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~Mouse
//
//  Description:
//
//      This is the destructor for a mouse object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Mouse::~Mouse(
)
{
    //  Nothing to do.
}
