///////////////////////////////////////////////////////////////////////////////
//
//  File:       6502mfc.h
//
//  Class:      CPU6502MFC - Concrete
//  
//  Hierarchy:  CPU6502MFC - CPU6502 - CPU - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class wraps Marat's 6502 emulation core.  This is the general
//      6502 core that can be used for any platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _6502mfc_h_
#define _6502mfc_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "cpu6502.h"
#include "m6502.h"

//  Forward class declarations.
class Game;
class AddrSpace;


///////////////////////////////////////////////////////////////////////////////
//  CPU6502MFC Class Definition
///////////////////////////////////////////////////////////////////////////////
class CPU6502MFC : public CPU6502
{
    public:

        //  Build method.
        static CPU6502MFC* s_build( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  Deletion.
        virtual ~CPU6502MFC ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        virtual void  reset     ( );
        virtual void  run       ( const int32 nCycles );
        virtual void  interrupt ( const int32 nType );

        //  Core access.
        virtual int32 getReg             ( int32 nReg );
        virtual void  setReg             ( int32 nReg, int32 nValue );

    protected:

        //  Creation is protected since a build method should be used.
        CPU6502MFC ( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  The initialization member function is called from the build method.
        virtual void init ( );

        //  The 6502 context.
        M6502 m_context;

    private:

};

#endif
