///////////////////////////////////////////////////////////////////////////////
//
//  File:       cpu6809.h
//
//  Class:      CPU6809 - Abstract
//  
//  Hierarchy:  CPU6809 - CPU - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class serves as a base class for any 6809 CPU emulation cores.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _cpu6809_h_
#define _cpu6809_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "cpu.h"

//  Forward class declarations.
class Game;
class AddrSpace;


///////////////////////////////////////////////////////////////////////////////
//  CPU6809 Class Definition
///////////////////////////////////////////////////////////////////////////////
class CPU6809 : public CPU
{
    public:

        //  All possible registers.
        enum
        {
            REG_DP = REG_CPU_CUSTOM,
            REG_U,
            REG_S,
            REG_X,
            REG_Y,
            REG_A,
            REG_B,
            REG_CC,

            REG_6809_CUSTOM
        };
      
        //  Deletion.
        virtual ~CPU6809 ( );

        //  Identification.
        virtual const KString& getType     ( ) const;
        virtual DWord          getAddrSize ( ) const;

#ifdef DEBUGGER
        virtual const char* dbgDisassemble ( DWord& rdwAddress );
        virtual const char* dbgRegister    ( const DWord dwNum );
#endif

    protected:

#ifdef DEBUGGER
        //  The possible opcode types.
        typedef enum
        {
            ILLEGAL = 0,
            DIRECT,
            IMMEDIATE,
            IMMEDIATEL,
            INHERENT,
            INDEXED,
            EXTENDED,
            RELATIVE,
            RELATIVEL,
            REGISTER0,
            REGISTER1,
            REGISTER2
        }
        OpcodeType;

        //  The information on an opcode.
        typedef struct
        {
            char*      pstrName;
            Byte       bNumBytes;
            OpcodeType eType;
        }
        OpcodeInfo;
#endif
            
        //  Creation is protected since a build method should be used.
        CPU6809 ( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );


        //  Static Member Data.
#ifdef DEBUGGER
        static OpcodeInfo sm_aOpInfoTable[ 256 ];
        static OpcodeInfo sm_aOpInfo10Table[ 256 ]; 
        static OpcodeInfo sm_aOpInfo11Table[ 256 ]; 
        static char*      sm_astrInterRegister[ 16 ];
        static char*      sm_astrIndexedRegister[ 4 ];
        static char*      sm_astrStackS[ 8 ];
        static char*      sm_astrStackU[ 8 ];
        static int32      sm_anBits[ 8 ];
#endif

    private:

};

#endif
