///////////////////////////////////////////////////////////////////////////////
//
//  File:    cpurh.cpp
//
//  Class:   ReadHandler
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class represents a Handler used for reading memory from an
//      address space or from a hardware port.  It is used by CPUs when 
//      accessing memory or ports.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers
#include <stdlib.h>

//  Application Headers.
#include "reptypes.h"
#include "cpurh.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ReadHandler
//
//  Description:
//
//      This is the main constructor for a read handler object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//      dwStart (input)
//          The start of the memory range that the handler is needed for.
//
//      dwEnd (input)
//          The end of the memory range that the handler is needed for.
//
//      pfHandler (input)
//          A pointer to the function used to handle the read.
//
//      pData (input)
//          A pointer to calldata.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ReadHandler::ReadHandler(
    const KString&  iName,
    DWord           dwStart,
    DWord           dwEnd,
    ReadFunc        pfHandler,
    void*           pData
)
:
    RepBase           ( iName ),
    m_dwStart         ( dwStart ),
    m_dwEnd           ( dwEnd ),
    m_pfHandler       ( pfHandler ),
    m_pData           ( pData )
{
    //  Make sure we didn't get junk.
    CONFIRM( dwStart <= dwEnd, "Read Handler start greater than end." );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~ReadHandler
//
//  Description:
//
//      This is the destructor for a read handler object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ReadHandler::~ReadHandler(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the read handler class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
ReadHandler::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "ReadHandler" );

    return( className );
}
