///////////////////////////////////////////////////////////////////////////////
//
//  File:    cpuwh.cpp
//
//  Class:   WriteHandler
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class represents a Handler used for writing to memory from an
//      address space or from a hardware port.  It is used by CPUs when 
//      accessing memory or ports.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers
#include <stdlib.h>

//  Application Headers.
#include "reptypes.h"
#include "cpuwh.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: WriteHandler
//
//  Description:
//
//      This is the main constructor for a write handler object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//      dwStart (input)
//          The start of the memory range that the handler is needed for.
//
//      dwEnd (input)
//          The end of the memory range that the handler is needed for.
//
//      pfHandler (input)
//          A pointer to the function used to handle the read.
//
//      pData (input)
//          A pointer to calldata.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
WriteHandler::WriteHandler(
    const KString&  iName,
    DWord           dwStart,
    DWord           dwEnd,
    WriteFunc       pfHandler,
    void*           pData
)
:
    RepBase           ( iName ),
    m_dwStart         ( dwStart ),
    m_dwEnd           ( dwEnd ),
    m_pfHandler       ( pfHandler ),
    m_pData           ( pData )
{
    //  Make sure we didn't get junk.
    CONFIRM( dwStart <= dwEnd, "Write Handler start greater than end." );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~WriteHandler
//
//  Description:
//
//      This is the destructor for a write handler object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
WriteHandler::~WriteHandler(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the read handler class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
WriteHandler::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "WriteHandler" );

    return( className );
}
