/*** Z80Em: Portable Z80 emulator *******************************************/
/***                                                                      ***/
/***                                Z80IO.h                               ***/
/***                                                                      ***/
/*** This file contains the prototypes for the functions accessing memory ***/
/*** and I/O                                                              ***/
/***                                                                      ***/
/*** Copyright (C) Marcel de Kogel 1996,1997                              ***/
/***     You are not allowed to distribute this software commercially     ***/
/***     Please, notify me, if you make any changes to this file          ***/
/****************************************************************************/


/****************************************************************************/
/* Input a byte from given I/O port                                         */
/****************************************************************************/
#define Z80_In(Port) ((Byte)CPU::sm_pCPU->readPort((Port)&0xff))

/****************************************************************************/
/* Output a byte to given I/O port                                          */
/****************************************************************************/
#define Z80_Out(Port,Value) (CPU::sm_pCPU->writePort((Port)&0xff,Value))

/****************************************************************************/
/* Read a byte from given memory location                                   */
/****************************************************************************/
#define Z80_RDMEM(A) ((Byte)CPU::sm_pCPU->readMem(A))

/****************************************************************************/
/* Write a byte to given memory location                                    */
/****************************************************************************/
#define Z80_WRMEM(A,V) (CPU::sm_pCPU->writeMem(A,V))

/****************************************************************************/
/* Z80_RDOP() is identical to Z80_RDMEM() except it is used for reading     */
/* opcodes. In case of system with memory mapped I/O, this function can be  */
/* used to greatly speed up emulation                                       */
/****************************************************************************/
#define Z80_RDOP(A) ((CPU::sm_pSpace->getDecryptBuffer())[A])

/****************************************************************************/
/* Z80_RDOP_ARG() is identical to Z80_RDOP() except it is used for reading  */
/* opcode arguments. This difference can be used to support systems that    */
/* use different encoding mechanisms for opcodes and opcode arguments       */
/****************************************************************************/
#define Z80_RDOP_ARG(A) ((CPU::sm_pSpace->getBuffer())[A])

/****************************************************************************/
/* Z80_RDSTACK() is identical to Z80_RDMEM() except it is used for reading  */
/* stack variables. In case of system with memory mapped I/O, this function */
/* can be used to slightly speed up emulation                               */
/****************************************************************************/
#define Z80_RDSTACK(A) ((Byte)CPU::sm_pCPU->readMem(A))

/****************************************************************************/
/* Z80_WRSTACK() is identical to Z80_WRMEM() except it is used for writing  */
/* stack variables. In case of system with memory mapped I/O, this function */
/* can be used to slightly speed up emulation                               */
/****************************************************************************/
#define Z80_WRSTACK(A,V) (CPU::sm_pCPU->writeMem(A,V))
