///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbgbps.h
//
//  Class:      DebugBreakPoints - Concrete
//  
//  Hierarchy:  DebugBreakPoints - DebugWindow - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a window in the Replay debugger that is
//      responsible for displaying all of the currently specified 
//      breakpoints.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

#ifndef _dbgbps_h_
#define _dbgbps_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "dbgwin.h"
#include "debugger.h"


///////////////////////////////////////////////////////////////////////////////
//  DebugBreakPoints Class Definition
///////////////////////////////////////////////////////////////////////////////
class DebugBreakPoints : public DebugWindow
{
    public:

        //  Creation/Deletion.
        DebugBreakPoints ( 
            const KString& iName, 
            Debugger*      pDebugger,
            const DWord    dwX,
            const DWord    dwY,
            const DWord    dwWidth,
            const DWord    dwHeight
        );
        virtual ~DebugBreakPoints ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void            draw    ( );
        virtual Debugger::Leave execute ( );

    protected:

        //  Member Data.

    private:

};

#endif

#endif
