///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbgcmd.h
//
//  Class:      DebugCommand - Concrete
//  
//  Hierarchy:  DebugCommand - DebugWindow - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a command line input window for the Replay+
//      debugger.  This window is where the user is able to type
//      instructions to the debugger.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

#ifndef _dbgcmd_h_
#define _dbgcmd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "dbgwin.h"
#include "debugger.h"
#include "keyb.h"



///////////////////////////////////////////////////////////////////////////////
//  DebugCommand Class Definition
///////////////////////////////////////////////////////////////////////////////
class DebugCommand : public DebugWindow
{
    public:

        //  Creation/Deletion.
        DebugCommand ( 
            const KString& iName, 
            Debugger*      pDebugger,
            const DWord    dwX,
            const DWord    dwY,
            const DWord    dwWidth,
            const DWord    dwHeight
        );
        virtual ~DebugCommand ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void            draw    ( );
        virtual Debugger::Leave execute ( );

    protected:

        //  The allowable commands.
        typedef enum
        {
            CMD_CONTINUE,
            CMD_NEXT,
            CMD_MEMORY,
            CMD_SOURCE,
            CMD_PC_BP,
            CMD_READ_BP,
            CMD_WRITE_BP,
            CMD_DISABLE_BP,
            CMD_ENABLE_BP,
            CMD_DELETE_BP,
            CMD_ASSIGN_MEM,
            CMD_SEARCH_MEM,
            CMD_CPU,
            CMD_TRACE,

            CMD_INVALID
        }
        Command;
             
        //  Utility.
        Debugger::Leave executeCmd   ( );
        Command         getCommand   ( );
        const char*     getParam     ( const DWord dwIdx );
        DWord           getParamDec  ( 
            const DWord dwIdx, 
            const DWord dwStart = ( DWord )-1, 
            const DWord dwEnd   = ( DWord )-1
        );
        DWord           getParamHex  ( 
            const DWord dwIdx,
            const DWord dwStart = ( DWord )-1,
            const DWord dwEnd   = ( DWord )-1
        );

        //  Command Processing.
        Debugger::Leave cmdContinue         ( );
        Debugger::Leave cmdNext             ( );
        Debugger::Leave cmdMemory           ( );
        Debugger::Leave cmdSource           ( );
        Debugger::Leave cmdBreakPoint       ( BreakPoint::Type eType );
        Debugger::Leave cmdEnableBreakPoint ( Byte bEnable );
        Debugger::Leave cmdDeleteBreakPoint ( );
        Debugger::Leave cmdAssignMemory     ( );
        Debugger::Leave cmdSearchMemory     ( );
        Debugger::Leave cmdChangeCPU        ( );
        Debugger::Leave cmdTrace            ( );


        //  Member Data.
        char  m_strCmd[ 80 ];
        DWord m_dwSearchStart;
        DWord m_dwNumSearchValues;
        DWord m_abSearchValues[ 64 ];

        //  Static Member Data.
        static Keyboard::KeyboardKey sm_aeAllowed[ ];
        static DWord                 sm_dwAllowed;
        static const DWord           sm_dwNone;

    private:

};

#endif

#endif
