///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbgsrc.h
//
//  Class:      DebugSource - Concrete
//  
//  Hierarchy:  DebugSource - DebugWindow - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a window in the Replay+ debugger that is
//      used to browse the disassembled source code for the current
//      CPU being executed.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

#ifndef _dbgsrc_h_
#define _dbgsrc_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "dbgwin.h"
#include "debugger.h"


///////////////////////////////////////////////////////////////////////////////
//  DebugSource Class Definition
///////////////////////////////////////////////////////////////////////////////
class DebugSource : public DebugWindow
{
    public:

        //  Creation/Deletion.
        DebugSource ( 
            const KString& iName, 
            Debugger*      pDebugger,
            const DWord    dwX,
            const DWord    dwY,
            const DWord    dwWidth,
            const DWord    dwHeight
        );
        virtual ~DebugSource ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void            draw    ( );
        virtual Debugger::Leave execute ( );

    protected:

        //  Utility.
        const char* indicator ( const DWord dwAddr );

        //  Member Data.
        DWord m_dwPrevAddr;
        DWord m_dwNextAddr;

    private:

};

#endif

#endif
