///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbgstat.h
//
//  Class:      DebugStatus - Concrete
//  
//  Hierarchy:  DebugStatus - DebugWindow - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a window in the Replay+ debugger that
//      is used to display various status messages pertaining to the
//      debugging procedure.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

#ifndef _dbgstat_h_
#define _dbgstat_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "dbgwin.h"
#include "debugger.h"



///////////////////////////////////////////////////////////////////////////////
//  DebugStatus Class Definition
///////////////////////////////////////////////////////////////////////////////
class DebugStatus : public DebugWindow
{
    public:

        //  Creation/Deletion.
        DebugStatus ( 
            const KString& iName, 
            Debugger*      pDebugger,
            const DWord    dwX,
            const DWord    dwY,
            const DWord    dwWidth,
            const DWord    dwHeight
        );
        virtual ~DebugStatus ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void            draw    ( );
        virtual Debugger::Leave execute ( );

    protected:

        //  Member Data.

    private:

};

#endif

#endif
