///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbgwin.h
//
//  Class:      DebugWindow - Abstract
//  
//  Hierarchy:  DebugWindow - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This abstract class serves as a base for all of the various 
//      windows that appear in the Replay+ debugger.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

#ifndef _dbgwin_h_
#define _dbgwin_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "debugger.h"

//  Forward class declarations.
class Debugger;
class Canvas;
class Keyboard;
class Clipping;
class Bitmap;
class GfxSet;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  DebugWindow Class Definition
///////////////////////////////////////////////////////////////////////////////
class DebugWindow : public RepBase
{
    public:

        //  Creation/Deletion.
        DebugWindow ( 
            const KString& iName, 
            Debugger*      pDebugger,
            const DWord    dwX,
            const DWord    dwY,
            const DWord    dwWidth,
            const DWord    dwHeight
        );
        virtual ~DebugWindow ( );

        //  Interface.
        virtual void            draw    ( );
        virtual Debugger::Leave execute ( ) = 0;
        void                    activate ( const Byte bActive );

    protected:

        //  Utility.
        void resetCurClipping ( );
        void writeLine        ( 
            const char* pstrLine, const Byte bHighlight = FALSE
        );


        //  Member Data.
        Debugger*           m_pDebugger;
        Canvas*             m_pCanvas;
        Keyboard*           m_pKeyboard;
        Bitmap*             m_pBitmap;
        GfxSet*             m_pFont; 
        int32               m_nFontWidth;
        int32               m_nFontHeight;
        ColourTable*        m_pColourTable;
        Clipping*           m_pFullClipping;
        Clipping*           m_pCurClipping;
        DWord               m_dwPageLength; 
        Byte                m_bActive;

    private:

};

#endif

#endif
