///////////////////////////////////////////////////////////////////////////////
//
//  File:       canvasd.h
//
//  Class:      CanvasDOS - Concrete
//  
//  Hierarchy:  CanvasDOS - Canvas - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents the Display of the Replay application on
//      the DOS platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _canvasd_h_
#define _canvasd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "canvas.h"
#include "paged.h"

//  Forward class declarations.
class Bitmap;

///////////////////////////////////////////////////////////////////////////////
//  CanvasDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class CanvasDOS : public Canvas
{
    public:

        //  Build method.
        static CanvasDOS* s_build( const KString& iName );

        //  Deletion.
        virtual ~CanvasDOS ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Page Interface.
        virtual void addPage    (
            const KString& pageName, 
            PageNumber     ePageNumber, 
            DWord          dwWidth, 
            DWord          dwHeight
        );
        virtual void turnPage   ( PageNumber ePageNumber );

        //  Bitmap Interface.
        virtual Bitmap*   createBitmap ( 
            const KString& iName,
            DWord          dwWidth,
            DWord          dwHeight,
            Byte           bForScreen = FALSE
        );
        virtual void      draw ( 
            Bitmap* pBitmap, int32 nX, int32 nY, DWord dwWidth, DWord dwHeight
        );

        //  Palette Interface.
        virtual DWord getNumColours ( ) const;
        virtual void  changeColour  ( 
            DWord dwIndex, DWord dwRed, DWord dwGreen, DWord dwBlue
        );

        //  General Interface.
        virtual Byte update ( );

    protected:

        //  Creation/Initialization.
                     CanvasDOS   ( const KString& iName );
        virtual void init        ( );


        //  Member Data.
        
    private:

};


#endif
