///////////////////////////////////////////////////////////////////////////////
//
//  File:       gamfactd.h
//
//  Class:      GameFactoryDOS - Concrete
//  
//  Hierarchy:  GameFactoryDOS - GameFactory - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This object is a factory for creating the games that Replay knows 
//      about.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _gamfactd_h_
#define _gamfactd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "gamfact.h"



///////////////////////////////////////////////////////////////////////////////
//  GameFactoryDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameFactoryDOS : public GameFactory
{
    public:

        //  Build method.
        static GameFactoryDOS* s_build( const KString& iName );

        //  Deletion.
        virtual ~GameFactoryDOS ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
   

    protected:

        //  Creation is protected.  Clients should use a build method.
        GameFactoryDOS ( const KString&  iName );

        //  This function should be called from the build method.
        virtual void init ( );

    private:

};


#endif
