///////////////////////////////////////////////////////////////////////////////
//
//  File:       joyd.h
//
//  Class:      JoystickDOS - Concrete
//  
//  Hierarchy:  JoystickDOS - Joystick - 
//                  DigitalController - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The JoystickDOS class encapsulates joystick access for the DOS
//      platform using the allegro joystick routines.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _joyd_h_
#define _joyd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "joy.h"


///////////////////////////////////////////////////////////////////////////////
//  JoystickDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class JoystickDOS : public Joystick
{
    public:

        //  Build method.
        static JoystickDOS* s_build( const KString& iName );

        //  Deletion.
        virtual ~JoystickDOS ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
        virtual Byte           update       ( );

    protected:

        //  Creation is protected.  Clients should use a build method.
        JoystickDOS ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );


        //  Member Data.

        //  Static Member Data.
        static Byte sm_bJoystickInitialized;

    private:

};

#endif
