///////////////////////////////////////////////////////////////////////////////
//
//  File:    moused.cpp
//
//  Class:   MouseDOS
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The MouseDOS class encapsulates mouse access for the DOS platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "moused.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: s_build
//
//  Description:
//
//      This is a factory method to create a DOS Mouse object.
//
//  Parameters:
//
//      iName (input)
//          The name of the object.
//
//  Returns:
//
//      A pointer to the new object.
//
///////////////////////////////////////////////////////////////////////////////
MouseDOS*
MouseDOS::s_build(
    const KString& iName
)
{
    //  Create the new object.
    MouseDOS* pThis = new MouseDOS( iName );

    //  Initialize the new object.
    pThis->init( );

    //  Send back the new mouse.
    return( pThis );
}





///////////////////////////////////////////////////////////////////////////////
//
//  Function: MouseDOS
//
//  Description:
//
//      This is the main constructor for the DOS Mouse object.  This is
//      a protected member.  Clients wishing to create a mouse object should
//      do so through the factory method.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
MouseDOS::MouseDOS(
    const KString&  iName
)
:
    Mouse ( iName )
{
    //  All initialization is done in init( ).
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: init
//
//  Description:
//
//      This is called to initialize the mouse object.  By using an init
//      member we get access to virtual functions that we wouldn't in the
//      constructor.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
MouseDOS::init(
)
{
    //  Call the base class.
    Mouse::init( );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~MouseDOS
//
//  Description:
//
//      This is the destructor for a DOS mouse object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
MouseDOS::~MouseDOS(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the mouse object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
MouseDOS::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "MouseDOS" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: update
//
//  Description:
//
//      This member should be called periodically to allow the
//      mouse object to update itself.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      TRUE  if a mouse state has changed.
//      FALSE if no mouse state has changed.
//
///////////////////////////////////////////////////////////////////////////////
Byte
MouseDOS::update(
)
{
    return( FALSE );
}
