///////////////////////////////////////////////////////////////////////////////
//
//  File:       nettcpd.h
//
//  Class:      NetworkTCPDOS - Concrete
//  
//  Hierarchy:  NetworkTCPDOS - Network - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The NetworkTCPDOS class implements network code between two or more 
//      Replay processes.  The TCP/IP protocol is used for communication.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _nettcpd_h_
#define _nettcpd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "network.h"


//  Forward class declarations.
class WinSocket;


///////////////////////////////////////////////////////////////////////////////
//  NetworkTCPDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class NetworkTCPDOS : public Network
{
    public:

        //  Creation/Deletion.
                 NetworkTCPDOS ( const KString& iName );
        virtual ~NetworkTCPDOS ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Connection.
        virtual Byte openNetwork     ( ConnectType eType );
        virtual Byte acceptClient    ( );
        virtual Byte connectToServer ( );
        virtual void closeNetwork    ( );
        virtual void closeConnection ( DWord dwConnection );

        //  Message passing.
        virtual void readMsg  ( const DWord dwConnection, Msg* pMsg );
        virtual void writeMsg ( const DWord dwConnection, Msg* pMsg );


    protected:

        //  Member Data.
        WinSocket*  m_pSocket;
        WinSocket** m_ppConnectSocketList;
        int32       m_nPort;
        KString     m_hostName;

        //  Static Member Data.
        static int sm_nDefaultPort;

    private:

};

#endif
