///////////////////////////////////////////////////////////////////////////////
//
//  File:       repfactd.h
//
//  Class:      ReplayFactoryDOS - Concrete
//  
//  Hierarchy:  ReplayFactoryDOS - ReplayFactory - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is the concrete factory for creating DOS based
//      objects used in Replay.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _repfactd_h_
#define _repfactd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repfact.h"


///////////////////////////////////////////////////////////////////////////////
//  ReplayFactoryDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class ReplayFactoryDOS : public ReplayFactory
{
    public:

        //  Deletion.
        virtual ~ReplayFactoryDOS ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

    protected:

        //  Creation.
        ReplayFactoryDOS ( const KString& iName );

        //  Factory methods.
        virtual Canvas*      createCanvas      ( const KString& iName );
        virtual Keyboard*    createKeyboard    ( const KString& iName );
        virtual Joystick*    createJoystick    ( const KString& iName );
        virtual Mouse*       createMouse       ( const KString& iName );
        virtual Sound*       createSound       ( const KString& iName );
        virtual Disk*        createDisk        ( const KString& iName );
        virtual Network*     createNetwork     ( const KString& iName );
        virtual Clock*       createClock       ( const KString& iName );
        virtual GameFactory* createGameFactory ( const KString& iName );
        virtual CPU*         createCPU         (
            const KString&        iName,
            const CPU::CPUType    eCPUType,
            Game*                 pGame,
            AddrSpace*            pSpace,
            const CPU::CPUPurpose ePurpose      = CPU::GAME,
            const Byte            bCONSERVATIVE = FALSE
        );


    private:

        //  Static Member Data.
        static ReplayFactoryDOS sm_replayFactoryDOS;
};


#endif
