///////////////////////////////////////////////////////////////////////////////
//
//  File:       soundd.h
//
//  Class:      SoundDOS - Concrete
//  
//  Hierarchy:  SoundDOS - Sound - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The SoundDOS class is a class encapsulating sound on the DOS
//      platform.  This requires the SEAL audio library v1.03.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _soundd_h_
#define _soundd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <audio.h>

//  Application Headers.
#include "sound.h"


///////////////////////////////////////////////////////////////////////////////
//  SoundDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class SoundDOS : public Sound
{
    public:

        //  Creation/Deletion.
                 SoundDOS ( const KString& iName );
        virtual ~SoundDOS ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  General Interface.
        virtual Byte update       ( );
        virtual void play         ( Sample* pSample, const Byte bLoop );
        virtual void playStreamed ( Sample* pSample );
        virtual void stop         ( const DWord dwChannel );

    protected:

        //  Utility.
        virtual DWord getNumChannels ( ) const;

        //  Member Data.
        HAC*         m_pVoiceList;
        LPAUDIOWAVE* m_pWaveList;

    private:

        //  Static Member Data.
        static const int32 sm_nNumVoices;
};

#endif
