///////////////////////////////////////////////////////////////////////////////
//
//  File:       winsockd.h
//
//  Class:      WinSockDOS - Concrete
//  
//  Hierarchy:  WinSockDOS - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used to provide access to the Win32 Winsock capabilities
//      from DOS.  Ideally, use of Indrek Mandre's libsocket or Dan Hedlund's
//      winsock library should be used, however I've had slight problems with
//      both and therefore this will be used for the time being.
//
//      Even though Indrek's and Dan's libraries aren't used, the code found
//      here owes a lot to their work.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _winsockd_h_
#define _winsockd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"


///////////////////////////////////////////////////////////////////////////////
//  WinSockDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class WinSockDOS : public RepBase
{
    public:

        //  Creation/Deletion.
        virtual ~WinSockDOS ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Singleton Access.
        static WinSockDOS& s_instance ( );
   
        //  Interface.
        int  getSocketP ( ) const;
        int  getSocketD ( ) const;
        void callVxD    ( int nFunction );

    private:

        //  Creation is private since this is a singleton.
        WinSockDOS ( const KString& iName );
        
        //  Helpers.
        void VxdLoadDevice ( char* pstrName );
        void VxdGetEntry   ( int* pEntry, int nID );
   
        //  Static Data Members.
        static Byte sm_bInitialized;
        static int  sm_nSocketP;
        static int  sm_nSocketD;
};

///////////////////////////////////////////////////////////////////////////////
//  WinSockDOS Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
int
WinSockDOS::getSocketP(
) const
{
    return( sm_nSocketP );
}

inline
int
WinSockDOS::getSocketD(
) const
{
    return( sm_nSocketD );
}

///////////////////////////////////////////////////////////////////////////////
//  Helper Functions.
///////////////////////////////////////////////////////////////////////////////
extern 
__inline__
void
_farpokex(
    unsigned short wSelector,
    unsigned long  dwOffset,
    void*          pSource,
    int            nLength
)
{
    __asm__ __volatile__(
        "pushl %%es\n"
        "movw  %w0, %%es\n"
        "rep\n"
        "movsb\n"
        "popl  %%es"
        : 
        : "rm"( wSelector ), "S" ( pSource ), "D" ( dwOffset ), "c" ( nLength )
        : "%ecx", "%edi", "%esi"
    );
}

extern
__inline__
void
_farpeekx(
    unsigned short wSelector,
    unsigned long  dwOffset,
    void*          pDest,
    int            nLength
)
{
    __asm__ __volatile__( 
        "pushl  %%ds\n"
        "movw   %w0,%%ds\n"
        "rep\n"
        "movsb\n"
        "popl   %%ds"
        :
        : "rm" ( wSelector ), "S" ( dwOffset ), "D" ( pDest ), "c" ( nLength )
        : "%ecx", "%edi", "%esi"
    );
}

#endif
