///////////////////////////////////////////////////////////////////////////////
//
//  File:       wsocket.h
//
//  Class:      WinSocket - Concrete
//  
//  Hierarchy:  WinSocket - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a WinSock style socket for use in DOS.
//      Much of this code was derived from Dan Hedlund's wsock library.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _wsocket_h_
#define _wsocket_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"


///////////////////////////////////////////////////////////////////////////////
//  WinSocket Class Definition
///////////////////////////////////////////////////////////////////////////////
class WinSocket : public RepBase
{
    public:

        //  Possible selection types.
        enum
        {
            SELECT_READ    = 0x01,
            SELECT_WRITE   = 0x02,
            SELECT_OOB     = 0x04,
            SELECT_ACCEPT  = 0x08,
            SELECT_CONNECT = 0x10,
            SELECT_CLOSE   = 0x20
        };

        //  Creation/Deletion.
                 WinSocket ( const KString& iName );
                 WinSocket ( const KString& iName, WinSocket& source );
        virtual ~WinSocket ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        int  getSocket ( ) const;
        Byte isValid   ( ) const;

        //  Interface.
        void bind    ( const int nPort );
        void listen  ( const int nMax );
        void connect ( const char* pstrHost, const int nPort );
        Byte select  ( const int nType );
        int  recv    ( void* pBuffer, int nLength );
        int  send    ( void* pBuffer, int nLength );

    private:

        //  A class used to hold an internet address.
        class InetAddress
        {
            public:
                short m_nFamily;
                short m_nPort;
                int   m_nAddress;
                char  acFill[ 8 ];
        };

        //  Private Data.
        int  m_nSocketP;
        int  m_nSocketD;
        int  m_nSocket;
        int  m_nSocketHandle;
        int  m_nAddressLength;
        char m_acAddress[ 16 ];
};

///////////////////////////////////////////////////////////////////////////////
//  WinSocket Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
int
WinSocket::getSocket(
) const
{
    return( m_nSocket );
}

inline
Byte
WinSocket::isValid(
) const
{
    return( m_nSocket ? TRUE : FALSE );
}


#endif
