///////////////////////////////////////////////////////////////////////////////
//
//  File:       buffer.h
//
//  Class:      Buffer - Concrete
//  
//  Hierarchy:  Buffer - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class can be used to hold a buffer of bytes.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _buffer_h_
#define _buffer_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <string.h>

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Buffer Class Definition
///////////////////////////////////////////////////////////////////////////////
class Buffer : public RepBase
{
    public:

        //  Creation/Deletion.
        Buffer ( 
            const KString& iName, const DWord dwSize, const Byte bSet = 0x00
        );
        Buffer ( 
            const KString& iName, const DWord dwSize, const Byte* pbSource
        );
        virtual ~Buffer ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Conversion.
        operator Byte* ( ) { return( m_pbBuffer ); }

        //  Access.
        Byte& operator[]       ( const DWord dwIndex ) const;
        DWord getSize          ( ) const;
        Byte* getBuffer        ( ) const;

        //  Utility.
        void clear                      ( const Byte bValue = 0x00 );
        virtual const Byte loadFile     (
            const DWord    dwAddress,
            const KString& gameId,
            const KString& fileName,
            const DWord    dwOffset = 0x0000,
            const DWord    dwLength = 0x0000
        );
        virtual const Byte loadFileSkip (
            const DWord    dwAddress,
            const KString& gameId,
            const KString& fileName,
            const DWord    dwOffset = 0x0000,
            const DWord    dwLength = 0x0000
        );


    protected:

        //  Member data.
        DWord m_dwSize;
        Byte* m_pbBuffer;

    private:

};


///////////////////////////////////////////////////////////////////////////////
//  Buffer Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Byte&
Buffer::operator[](
    const DWord dwIndex
) const
{
    ASSERT( dwIndex < m_dwSize );
    return( m_pbBuffer[ dwIndex ] );
}

inline
DWord
Buffer::getSize(
) const
{
    return( m_dwSize );
}

inline
Byte*
Buffer::getBuffer(
) const
{
    return( m_pbBuffer );
}

inline
void
Buffer::clear(
    const Byte bValue /* = 0x00 */
)
{
    memset( ( void* )m_pbBuffer, bValue, m_dwSize );
}

#endif
