///////////////////////////////////////////////////////////////////////////////
//
//  File:       colour.h
//
//  Class:      Colour - Concrete
//  
//  Hierarchy:  Colour - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class contains the definition of a colour.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _colour_h_
#define _colour_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"



///////////////////////////////////////////////////////////////////////////////
//  Colour Class Definition
///////////////////////////////////////////////////////////////////////////////
class Colour : public RepBase
{
    public:

        //  Creation/Deletion.
        Colour ( 
            const DWord    dwRed   = 0x0000, 
            const DWord    dwGreen = 0x0000,
            const DWord    dwBlue  = 0x0000
        );
        virtual ~Colour ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        void  set      ( DWord dwRed, DWord dwGreen, DWord dwBlue );
        void  get      ( DWord* pdwRed, DWord* pdwGreen, DWord* pdwBlue ) const;
        void  lock     ( );
        void  unlock   ( );
        Byte  isLocked ( ) const;


    protected:

        //  Member data.
        DWord                 m_dwRed;
        DWord                 m_dwGreen;
        DWord                 m_dwBlue;
        DWord                 m_dwLocked;
 
    private:

};


///////////////////////////////////////////////////////////////////////////////
//  Input Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
void
Colour::set(
    DWord dwRed,
    DWord dwGreen,
    DWord dwBlue
)
{
    m_dwRed   = dwRed;
    m_dwGreen = dwGreen;
    m_dwBlue  = dwBlue;
}

inline
void
Colour::get(
    DWord* pdwRed, 
    DWord* pdwGreen, 
    DWord* pdwBlue
) const
{
    *pdwRed   = m_dwRed;
    *pdwGreen = m_dwGreen;
    *pdwBlue  = m_dwBlue;
}

inline
void
Colour::lock(
)
{
    m_dwLocked += 1;
}

inline
void
Colour::unlock(
)
{
    CHECK0( m_dwLocked > 0, "Colour unlocked when not locked" );
    m_dwLocked -= 1;
}

inline
Byte
Colour::isLocked(
) const
{
    return( m_dwLocked ? TRUE : FALSE );
}

#endif
