///////////////////////////////////////////////////////////////////////////////
//
//  File:       gamefind.h
//
//  Class:      GameFinder - Concrete
//  
//  Hierarchy:  GameFinder - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used by the Game Factory to keep track of where game
//      drivers are found so that game objects can be created on request. 
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _gamefind_h_
#define _gamefind_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"


//  Forward class declarations.
class GameInfo;

///////////////////////////////////////////////////////////////////////////////
//  GameFinder Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameFinder : public RepBase
{
    public:

        //  Creation/Deletion.
        GameFinder ( 
            const KString& iName, 
            GameInfo*      pGameInfo,
            const KString& fileName,
            void*          pHandle
        );
        virtual ~GameFinder ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        GameInfo*      getGameInfo ( ) const;
        const KString& getFileName ( ) const;
        void*          getHandle   ( ) const;

    protected:

        //  Member data.
        GameInfo* m_pGameInfo;
        KString   m_fileName;
        void*     m_pHandle;

    private:

};


///////////////////////////////////////////////////////////////////////////////
//  GameFinder Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
GameInfo*
GameFinder::getGameInfo(
) const
{
    return( m_pGameInfo );
}

inline
const
KString&
GameFinder::getFileName(
) const
{
    return( m_fileName );
}

inline
void*
GameFinder::getHandle(
) const
{
    return( m_pHandle );
}

#endif
