///////////////////////////////////////////////////////////////////////////////
//
//  File:       hiscore.h
//
//  Class:      HiScore - Concrete
//  
//  Hierarchy:  HiScore - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used to keep track of the hi scores for a game.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _hiscore_h_
#define _hiscore_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "kplist.h"

//  Forward Class Declarations.
class Game;

///////////////////////////////////////////////////////////////////////////////
//  VBlank Class Definition
///////////////////////////////////////////////////////////////////////////////
class HiScore : public RepBase
{
    public:

        //  Creation/Deletion.
                 HiScore ( const KString& iName, Game* pGame );
        virtual ~HiScore ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        void  enable     ( );
        void  disable    ( );
        Byte  loadScores ( );
        Byte  saveScores ( );
        void  setTrigger ( DWord dwTriggerCount );
        DWord getTrigger ( ) const;
        void  addRange   ( Byte* pbLocation, DWord dwLength );
        

    protected:

        //  The following embedded class is responsible for holding on
        //  to a range of bytes that store a portion of the high scores.
        class ScoreRange
        {
            public:
                Byte* m_pbLocation;
                DWord m_dwLength;
                char  m_name[16];
        };

        //  Member data.
        Byte                 m_bEnabled;
        Byte                 m_bLoaded;
        Game*                m_pGame;
        DWord                m_dwTriggerCount;
        DWord                m_dwCurTriggerCount;
        KPtrList<ScoreRange> m_rangeList;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  HiScore Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
void
HiScore::enable(
)
{
    m_bEnabled = TRUE;
}

inline
void
HiScore::disable(
)
{
    m_bEnabled = FALSE;
}

inline
void
HiScore::setTrigger(
    DWord dwTriggerCount
)
{
    m_dwTriggerCount = dwTriggerCount;
}

inline
DWord
HiScore::getTrigger(
) const
{
    return( m_dwTriggerCount );
}

#endif
