///////////////////////////////////////////////////////////////////////////////
//
//  File:       schedule.h
//
//  Class:      Schedule - Concrete
//  
//  Hierarchy:  Schedule - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The scheduler is a class that is used for controlling the execution
//      of the CPUs.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _schedule_h_
#define _schedule_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kplist.h"
#include "kpslist.h"
#include "slice.h"
#include "cpu.h"


//  Forward class declarations.
class Screen;


///////////////////////////////////////////////////////////////////////////////
//  Scheduler Class Definition
///////////////////////////////////////////////////////////////////////////////
class Scheduler : public RepBase
{
    public:

        //  Creation/Deletion.
                 Scheduler ( const KString& iName );
        virtual ~Scheduler ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        void scheduleCPUs  ( 
            KPtrList<CPU>& rCPUList,
            const int      nCPUInterleave,
            Screen*        pScreen
        );
        void updateCPUs    ( );
        
        //  Access.
        Slice* getSlice           ( ) const;
        double getFramePercent    ( ) const;

    protected:

    private:

        //  Member data.
        KPtrSortList<Slice>   m_sliceList;
        Slice*                m_pSlice;
        Screen*               m_pScreen;

        //  Static Utility Functions.       
        static void s_addChunkToList( 
            double* pfChunkList, DWord& rdwChunkSize, const double fChunk
        );

        //  Static Comparison Functions.
        static int s_compareChunks( const void* pChunk1, const void* pChunk2 );
        static int s_compareSlices( const void* pSlice1, const void* pSlice2 );
};


///////////////////////////////////////////////////////////////////////////////
//  Scheduler Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Slice*
Scheduler::getSlice(
) const
{
    return( m_pSlice );
}

inline
double
Scheduler::getFramePercent( 
) const
{
    return( 
        ( double )
        ( m_pSlice->m_nStart + m_pSlice->m_pCPU->getCyclesExecuted( ) ) / 
        m_pSlice->m_nTotal
    );
}

#endif
