///////////////////////////////////////////////////////////////////////////////
//
//  File:    _amidar.cpp
//
//  Class:   GameAmidarBase
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is an abstract class that serves as a base for all Amidar games.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////
//  System Headers.

//  Application Headers.
#include "_amidar.h"
#include "hiscore.h"
#include "space.h"
#include "input.h"
#include "dip.h"




///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameAmidarBase
//
//  Description:
//
//      This is the main constructor for an Amidar game object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameAmidarBase::GameAmidarBase(
    const KString& iName
)
:
    GameAmidarHW      ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameAmidarBase
//
//  Description:
//
//      This is the destructor for an Amidar game object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameAmidarBase::~GameAmidarBase(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of an Amidar game.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameAmidarBase::startUpInput(
)
{
    //  Allow the base class to create the inputs and set up the controls.
    GameAmidarHW::startUpInput( );

    //  Set up the dip switches.
    DipSwitch* pDip;
    pDip = m_dipSwitchList.add(
        new DipSwitch( "IN1", m_pInputIN1->getLocation( ), TRUE )
    );
    pDip->addSetting(
        "Lives",
        0x03,
        "3 Lives",
        "4 Lives",
        "5 Lives",
        "255 Lives"
    );
    pDip = m_dipSwitchList.add(
        new DipSwitch( "IN2", m_pInputIN2->getLocation( ), TRUE )
    );
    pDip->addSetting(
        "Demo Sounds",
        0x02,
        "Demo Sounds Off",
        "Demo Sounds On"
    );
    pDip->addSetting(
        "Cabinet",
        0x08,
        "Cocktail Cabinet",
        "Upright Cabinet"
    );
    pDip->addSetting(
        "Unknown1",
        0x20,
        "??? Off",
        "??? On"
    );
    pDip->addSetting(
        "Unknown2",
        0x80,
        "??? Off",
        "??? On"
    );
    pDip = m_dipSwitchList.add(
        new DipSwitch( "DSW", m_pInputDSW->getLocation( ), TRUE )
    );
    pDip->addSetting(
        "Coin A",
        0x0f,
        "Coin A: 1 Coin/1 Credit", 
        "Coin A: 2 Coins/3 Credits",
        "Coin A: 1 Coin/5 Credits",
        "Coin A: 3 Coins/4 Credits",
        "Coin A: 1 Coin/3 Credits", 
        "Coin A: 3 Coins/1 Credit",
        "Coin A: 1 Coin/7 Credits",
        "Coin A: 4 Coins/3 Credits",
        "Coin A: 1 Coin/2 Credits", 
        "Coin A: 2 Coins/5 Credits",
        "Coin A: 1 Coin/6 Credits", 
        "Coin A: 4 Coins/1 Credit", 
        "Coin A: 1 Coin/4 Credits", 
        "Coin A: 3 Coins/2 Credits", 
        "Coin A: 2 Coins/1 Credit", 
        "Coin A: Free Play"
    );
    pDip->addSetting(
        "Coin B",
        0xf0,
        "Coin B: 1 Coin/1 Credit", 
        "Coin B: 2 Coins/3 Credits",
        "Coin B: 1 Coin/5 Credits",
        "Coin B: 3 Coins/4 Credits",
        "Coin B: 1 Coin/3 Credits", 
        "Coin B: 3 Coins/1 Credit",
        "Coin B: 1 Coin/7 Credits",
        "Coin B: 4 Coins/3 Credits",
        "Coin B: 1 Coin/2 Credits", 
        "Coin B: 2 Coins/5 Credits",
        "Coin B: 1 Coin/6 Credits", 
        "Coin B: 4 Coins/1 Credit", 
        "Coin B: 1 Coin/4 Credits", 
        "Coin B: 3 Coins/2 Credits", 
        "Coin B: 2 Coins/1 Credit", 
        "Coin B: Free Play"
    );


    //  The Amidar high scores are stored at:
    //      0x81c0: 10 scores * 3 bytes/score = 30 bytes.
    //      0x8200: 10 scores * 3 bytes/score = 30 bytes.
    //      0x80a8: 1 top score * 3 bytes/score = 3 bytes.
    //  Amidar writes to this area twice before settling down.
    m_pHiScore = new HiScore( "HiScore", this );
    m_pHiScore->setTrigger( 2 );
    m_pHiScore->addRange( m_pSpaceGame->getBuffer( ) + 0x81c0, 30 );
    m_pHiScore->addRange( m_pSpaceGame->getBuffer( ) + 0x8200, 30 );
    m_pHiScore->addRange( m_pSpaceGame->getBuffer( ) + 0x80a8,  3 );
}

void
GameAmidarBase::startUpMemMap(
)
{
    //  Register the high score handler first.
    m_pCPUGame->writeMemHandler(
        "Score Trigger",  0x81dd, 0x81dd, s_writeHiScore,      m_pHiScore
    ); 

    //  Allow the base class to register the remainder of the handlers.
    GameAmidarHW::startUpMemMap( );
}

void
GameAmidarBase::startUpColour(
)
{
    //  The amidar colour PROM.
    static Byte abColourPROM[ ] =
    {
        0x00, 0x07, 0xc0, 0xb6, 0x00, 0x38, 0xc5, 0x67, 
        0x00, 0x30, 0x07, 0x3f, 0x00, 0x07, 0x30, 0x3f,
        0x00, 0x3f, 0x30, 0x07, 0x00, 0x38, 0x67, 0x3f,
        0x00, 0xff, 0x07, 0xdf, 0x00, 0xf8, 0x07, 0xff
    };

    //  Assign the colour PROM.
    m_pColourPROM = new Buffer( 
        "Colour PROM", 
        sizeof( abColourPROM ) / sizeof( abColourPROM[ 0 ] ),
        abColourPROM
    );

    //  The base class will initialize the colours.
    GameAmidarHW::startUpColour( );
}
