///////////////////////////////////////////////////////////////////////////////
//
//  File:       _amihw.h
//
//  Class:      GameAmidarHW - Abstract
//  
//  Hierarchy:  GameAmidarHW - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is an abstract class that serves as a base for a series of
//      games from Stern that is based on what we'll call the "Amidar" 
//      hardware.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __amihw_h_
#define __amihw_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "game.h"


///////////////////////////////////////////////////////////////////////////////
//  GameAmidarHW Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameAmidarHW : public Game
{
    public:

        //  Creation/Deletion.
                 GameAmidarHW ( const KString& iName );
        virtual ~GameAmidarHW ( );

        //  Interface.
        virtual void  updateDisplay          ( 
            Bitmap* pScreen, Bitmap* pTempScreen 
        );

    protected:

        //  Local Startup functions.
        virtual void startUpSpace    ( );
        virtual void startUpCPU      ( );
        virtual void startUpInput    ( );
        virtual void startUpGraphics ( );
        virtual void startUpColour   ( );
        virtual void startUpSound    ( );
        virtual void startUpMemMap   ( );

        //  Non-default memory handlers.
        static DWord s_readTimer         ( 
            DWord dwAddress, ReadHandler* pHandler 
        );
        static void s_writeAttributes    (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeSoundIRQ      (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );

        //  Member Data.
        Input*        m_pInputIN0;
        Input*        m_pInputIN1;
        Input*        m_pInputIN2;
        Input*        m_pInputDSW;
        AddrSpace*    m_pSpaceGame;
        AddrSpace*    m_pSpaceSound;
        Buffer*       m_pBufferGfx;
        Buffer*       m_pSoundCommand;
        CPU*          m_pCPUGame;
        CPU*          m_pCPUSound;
        Buffer*       m_pDirty;
        Byte*         m_pbVideoRAM;
        Byte*         m_pbAttributeRAM;
        Byte*         m_pbSpriteRAM;
        GfxSet*       m_pGfxSetChar;
        GfxSet*       m_pGfxSetSprite;
        ColourTable*  m_pColTable;
        SoundDevice*  m_pAY8910One;
        SoundDevice*  m_pAY8910Two;
        Clipping*     m_pClipping;
        Clipping*     m_pSpriteClipping;

    private:

};

#endif
