///////////////////////////////////////////////////////////////////////////////
//
//  File:       _bm6809.h
//
//  Class:      GameBallyMidway6809 - Abstract
//  
//  Hierarchy:  GameBallyMidway6809 - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is an abstract class that serves as a base for a series of
//      games from Bally Midway that run on hardware with two Motorola
//      6809 processors.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __bm6809_h_
#define __bm6809_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "game.h"


//  Forward class declarations.
class WaveForm;

///////////////////////////////////////////////////////////////////////////////
//  GameBallyMidway6809 Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameBallyMidway6809 : public Game
{
    public:

        //  Creation/Deletion.
                 GameBallyMidway6809 ( const KString& iName );
        virtual ~GameBallyMidway6809 ( );

        //  Interface.
        virtual void  updateDisplay          ( 
            Bitmap* pScreen, Bitmap* pTempScreen 
        );

    protected:

        //  Local Startup functions.
        virtual void startUpSpace    ( );
        virtual void startUpCPU      ( );
        virtual void startUpInput    ( );
        virtual void startUpGraphics ( );
        virtual void startUpColour   ( );
        virtual void startUpSound    ( );

        //  Non-default memory handlers.
        static void s_writeSoundEnable    (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeSoundRegister  (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeScreenRotate (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );

        //  Member Data.
        Input*        m_pInputDSW0;
        Input*        m_pInputDSW1;
        Input*        m_pInputIN0;
        Input*        m_pInputIN1;
        Input*        m_pInputIN2;
        AddrSpace*    m_pSpaceGame;
        AddrSpace*    m_pSpaceSound;
        Buffer*       m_pBufferChar;
        Buffer*       m_pBufferSprite;
        CPU*          m_pCPUGame;
        CPU*          m_pCPUSound;
        Buffer*       m_pDirty;
        Byte*         m_pbVideoRAM;
        Byte*         m_pbColourRAM;
        Byte*         m_pbSprite1RAM;
        Byte*         m_pbSprite2RAM;
        Byte*         m_pbSprite3RAM;
        Byte*         m_pbSoundRAM;
        GfxSet*       m_pGfxSetChar;
        GfxSet*       m_pGfxSetSprite;
        ColourTable*  m_pColTableChar;
        ColourTable*  m_pColTableSprite;
        WaveForm*     m_pWaveForm;

    private:

};

#endif
