///////////////////////////////////////////////////////////////////////////////
//
//  File:       _bnj.h
//
//  Class:      GameBumpNJumpBase - Abstract
//  
//  Hierarchy:  GameBumpNJumpBase - GameDataEastIGS - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is an abstract class that serves as a base for the various 
//      versions of Bump'N'Jump.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __bnj_h_
#define __bnj_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "_decoigs.h"



///////////////////////////////////////////////////////////////////////////////
//  GameBumpNJumpBase Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameBumpNJumpBase : public GameDataEastIGS
{
    public:

        //  Creation/Deletion.
                 GameBumpNJumpBase ( const KString& iName );
        virtual ~GameBumpNJumpBase ( );

        //  Interface.
        virtual void  updateDisplay          ( 
            Bitmap* pScreen, Bitmap* pTempScreen 
        );

    protected:

        //  Local Startup functions.
        virtual void startUpSpace    ( );
        virtual void startUpInput    ( );
        virtual void startUpGraphics ( );
        virtual void startUpMemMap   ( );

        //  Non-default memory handlers.
        static void s_writeScreenRotate (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );

        //  Member Data.
        Buffer*      m_pDirty;
        Byte*        m_pbBGRAM;

    private:

};

#endif
