///////////////////////////////////////////////////////////////////////////////
//
//  File:       _btime.h
//
//  Class:      GameBurgerTimeBase - Abstract
//  
//  Hierarchy:  GameBurgerTimeBase - GameDataEastIGS - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the game object for Burgertime.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __btime_h_
#define __btime_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "_decoigs.h"


///////////////////////////////////////////////////////////////////////////////
//  Game Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameBurgerTimeBase : public GameDataEastIGS
{
    public:

        //  Creation/Deletion.
        GameBurgerTimeBase ( 
            const KString& iName,
            Word*          pwAddresses,
            DWord          dwNumAddresses
        );
        virtual ~GameBurgerTimeBase ( );

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        virtual void  updateDisplay          ( 
            Bitmap* pScreen, Bitmap* pTempScreen 
        );

    protected:

        //  Local Startup functions.
        virtual void startUpSpace    ( );
        virtual void startUpInput    ( );
        virtual void startUpGraphics ( );
        virtual void startUpMemMap   ( );

        //  A function to decrypt the Burgertime Game ROMs.
        virtual void decryptROMs  ( );

        //  Non-default memory handlers.
        static void s_writeMapNumber    (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );

        //  Member Data.
        Word*         m_pwAddresses;
        DWord         m_dwNumAddresses;
        Buffer*       m_pBufferMap;
        Byte          m_bMapNumber;
        Byte          m_bMapDirty; 

    private:

};

#endif
