///////////////////////////////////////////////////////////////////////////////
//
//  File:       _decoigs.h
//
//  Class:      GameDataEastIGS - Abstract
//  
//  Hierarchy:  GameDataEastIGS - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is an abstract class that serves as a base for a series of
//      games by Data East that were part of the Data East Interchangeable
//      Game System.  The hardware allowed a new game to be loaded simply
//      by changing a *tape* containing the program code and the marquee.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __decoigs_h_
#define __decoigs_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "game.h"
#include "cpu.h"

//  Forward class declarations.
class CommandQueue;

///////////////////////////////////////////////////////////////////////////////
//  GameDataEastIGS Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameDataEastIGS : public Game
{
    public:

        //  Creation/Deletion.
        GameDataEastIGS ( 
            const KString& iName, 
            const Byte     bScrollingBG,
            const int32    nMirrorOffset,
            const Byte     bReverseCoin
        );
        virtual ~GameDataEastIGS ( );

    protected:

        //  Local Startup functions.
        virtual void startUpSpace    ( );
        virtual void startUpCPU      ( );
        virtual void startUpInput    ( );
        virtual void startUpGraphics ( );
        virtual void startUpColour   ( );
        virtual void startUpSound    ( );

        //  A function to decrypt the Game ROMs.
        virtual void decryptROMs      ( );

        //  Helpers for updating the display.
        void updateCharacters         ( Bitmap* pScreen );
        void updateSprites            ( Bitmap* pScreen );

        //  The interrupt handler for the CPUs.
        static int32 s_gameInterrupt  ( CPU* pCPU, Game* pGame );
        static int32 s_soundInterrupt ( CPU* pCPU, Game* pGame );

        //  Non-default memory handlers.
        static DWord s_readMirror       (
            DWord dwAddress, ReadHandler* pHandler 
        );
        static void s_writePalette      (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeMirror       (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeSoundCmd      (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );

        //  Member Data.
        Input*        m_pInputP1;
        Input*        m_pInputP2;
        Input*        m_pInputCoin;
        Input*        m_pInputDip1;
        Input*        m_pInputDip2;
        AddrSpace*    m_pSpaceGame;
        AddrSpace*    m_pSpaceSound;
        Buffer*       m_pBufferFG;
        Buffer*       m_pBufferBG;
        CommandQueue* m_pSoundCommand;
        CPU*          m_pCPUGame;
        CPU*          m_pCPUSound;
        GfxSet*       m_pGfxSetFG;
        GfxSet*       m_pGfxSetBG;
        GfxSet*       m_pGfxSetSprite;
        ColourTable*  m_pColTableFG;
        ColourTable*  m_pColTableBG;
        SoundDevice*  m_pAY8910One;
        SoundDevice*  m_pAY8910Two;
        Byte*         m_pbVideoLoRAM;
        Byte*         m_pbVideoHiRAM;
        Byte*         m_pbScrollHi;
        Byte*         m_pbScrollLo;
        Byte*         m_pbSoundControl;
        Byte          m_bCoin;
        Clipping*     m_pClipping;
        Byte          m_bScrollingBG;
        int32         m_nMirrorOffset;
        Byte          m_bReverseCoin;

    private:

};

#endif
