///////////////////////////////////////////////////////////////////////////////
//
//  File:    amidar.cpp
//
//  Class:   GameAmidar
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for the US version of Amidar.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////
//  Application Headers.
#include "amidar.h"
#include "gameinfo.h"
#include "space.h"
#include "dip.h"
#include "buffer.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "amidar",

    ASSIGN_GAME_NAME,
        "Amidar (US)",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Robert Anschuetz  (game)",
        "Alan J. McCormick (colour)",
        "Kevin Brisley     (score)",

    ASSIGN_GAME_REQD_FILES,
        "amidarus.2c",
        "amidarus.2e",
        "amidarus.2f",
        "amidarus.2h",
        "amidarus.2j",
        "amidarus.5c",
        "amidarus.5d",
        "amidarus.5f",
        "amidarus.5h",

FOR( amidar, GameAmidar )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameAmidar
//
//  Description:
//
//      This is the main constructor for the US version of Amidar.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameAmidar::GameAmidar(
    const KString& iName
)
:
    GameAmidarBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameAmidar
//
//  Description:
//
//      This is the destructor for the US version of Amidar.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameAmidar::~GameAmidar(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Amidar US game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameAmidar::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameAmidar" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of the US Amidar.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameAmidar::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0000, m_pGameInfo->getGameId( ), "amidarus.2c" );
    m_pSpaceGame->loadFile( 0x1000, m_pGameInfo->getGameId( ), "amidarus.2e" );
    m_pSpaceGame->loadFile( 0x2000, m_pGameInfo->getGameId( ), "amidarus.2f" );
    m_pSpaceGame->loadFile( 0x3000, m_pGameInfo->getGameId( ), "amidarus.2h" );
    m_pSpaceGame->loadFile( 0x4000, m_pGameInfo->getGameId( ), "amidarus.2j" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0000, m_pGameInfo->getGameId( ), "amidarus.5c" );
    m_pSpaceSound->loadFile( 0x1000, m_pGameInfo->getGameId( ), "amidarus.5d" );
    
    //  Load in the graphic ROMs.  They've got some extra space at the end
    //  so only load in the first half of each.
    m_pBufferGfx->loadFile( 
        0x0000, m_pGameInfo->getGameId( ), "amidarus.5f", 0x0000, 0x0800 
    );
    m_pBufferGfx->loadFile( 
        0x0800, m_pGameInfo->getGameId( ), "amidarus.5h", 0x0000, 0x0800 
    );
}

void
GameAmidar::startUpInput(
)
{
    //  The base class will create the inputs and setup the controls.
    GameAmidarBase::startUpInput( );

    //  The only difference between the dip switches of the various versions
    //  is the one that controls the bonus lives.
    m_dipSwitchList[ 1 ]->addSetting(
        "Bonus",
        0x04,
        "Bonus Lives at 50000/80000",
        "Bonus Lives at 30000/70000"
    );
}
