///////////////////////////////////////////////////////////////////////////////
//
//  File:    amidarjp.cpp
//
//  Class:   GameAmidarJapan
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for the Japan version of Amidar.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////
//  Application Headers.
#include "amidarjp.h"
#include "gameinfo.h"
#include "space.h"
#include "dip.h"
#include "buffer.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "amidarjp",

    ASSIGN_GAME_NAME,
        "Amidar (Japan)",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Robert Anschuetz  (game)",
        "Alan J. McCormick (colour)",
        "Kevin Brisley     (score)",

    ASSIGN_GAME_REQD_FILES,
        "amidar.2c",
        "amidar.2e",
        "amidar.2f",
        "amidar.2h",
        "amidar.5c",
        "amidar.5d",
        "amidar.5f",
        "amidar.5h",

FOR( amidarjp, GameAmidarJapan )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameAmidarJapan
//
//  Description:
//
//      This is the main constructor for the Japan version of Amidar.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameAmidarJapan::GameAmidarJapan(
    const KString& iName
)
:
    GameAmidarBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameAmidarJapan
//
//  Description:
//
//      This is the destructor for the Japan version of Amidar.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameAmidarJapan::~GameAmidarJapan(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Amidar Japan game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameAmidarJapan::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameAmidarJapan" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of the Japan version of Amidar.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameAmidarJapan::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0000, m_pGameInfo->getGameId( ), "amidar.2c" );
    m_pSpaceGame->loadFile( 0x1000, m_pGameInfo->getGameId( ), "amidar.2e" );
    m_pSpaceGame->loadFile( 0x2000, m_pGameInfo->getGameId( ), "amidar.2f" );
    m_pSpaceGame->loadFile( 0x3000, m_pGameInfo->getGameId( ), "amidar.2h" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0000, m_pGameInfo->getGameId( ), "amidar.5c" );
    m_pSpaceSound->loadFile( 0x1000, m_pGameInfo->getGameId( ), "amidar.5d" );
    
    //  Load in the graphic ROMs.
    m_pBufferGfx->loadFile( 0x0000, m_pGameInfo->getGameId( ), "amidar.5f" );
    m_pBufferGfx->loadFile( 0x0800, m_pGameInfo->getGameId( ), "amidar.5h" );
}

void
GameAmidarJapan::startUpInput(
)
{
    //  The base class will create the inputs and setup the controls.
    GameAmidarBase::startUpInput( );

    //  The only difference between the dip switches of the various versions
    //  is the one that controls the bonus lives.
    m_dipSwitchList[ 1 ]->addSetting(
        "Bonus",
        0x04,
        "Bonus Lives at 50000/50000",
        "Bonus Lives at 30000/50000"
    );
}
