///////////////////////////////////////////////////////////////////////////////
//
//  File:    amigo.cpp
//
//  Class:   GameAmigo
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for a bootleg version of Amidar called Amigo.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////
//  Application Headers.
#include "amigo.h"
#include "gameinfo.h"
#include "space.h"
#include "dip.h"
#include "buffer.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "amigo",

    ASSIGN_GAME_NAME,
        "Amigo",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Robert Anschuetz  (game)",
        "Alan J. McCormick (colour)",
        "Kevin Brisley     (score)",

    ASSIGN_GAME_REQD_FILES,
        "2732.a1",
        "2732.a2",
        "2732.a3",
        "2732.a4",
        "2716.a5",
        "2716.a6",
        "2732.a7",
        "2732.a8",

FOR( amigo, GameAmigo )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameAmigo
//
//  Description:
//
//      This is the main constructor for bootleg Amidar.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameAmigo::GameAmigo(
    const KString& iName
)
:
    GameAmidarBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameAmigo
//
//  Description:
//
//      This is the destructor for the bootleg Amidar.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameAmigo::~GameAmigo(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the bootleg Amidar.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameAmigo::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameAmigo" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of the bootleg Amidar.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameAmigo::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0000, m_pGameInfo->getGameId( ), "2732.a1" );
    m_pSpaceGame->loadFile( 0x1000, m_pGameInfo->getGameId( ), "2732.a2" );
    m_pSpaceGame->loadFile( 0x2000, m_pGameInfo->getGameId( ), "2732.a3" );
    m_pSpaceGame->loadFile( 0x3000, m_pGameInfo->getGameId( ), "2732.a4" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0000, m_pGameInfo->getGameId( ), "2732.a7" );
    m_pSpaceSound->loadFile( 0x1000, m_pGameInfo->getGameId( ), "2732.a8" );
    
    //  Load in the graphic ROMs.
    m_pBufferGfx->loadFile( 0x0000, m_pGameInfo->getGameId( ), "2716.a6" );
    m_pBufferGfx->loadFile( 0x0800, m_pGameInfo->getGameId( ), "2716.a5" );
}

void
GameAmigo::startUpInput(
)
{
    //  The base class will create the inputs and setup the controls.
    GameAmidarBase::startUpInput( );

    //  The only difference between the dip switches of the various versions
    //  is the one that controls the bonus lives.
    m_dipSwitchList[ 1 ]->addSetting(
        "Bonus",
        0x04,
        "Bonus Lives at 50000/80000",
        "Bonus Lives at 30000/70000"
    );
}
