///////////////////////////////////////////////////////////////////////////////
//
//  File:    bnj.cpp
//
//  Class:   GameBumpNJump
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for Bump'n'Jump with DECO copyright.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "bnj.h"
#include "gameinfo.h"
#include "space.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "bnj",

    ASSIGN_GAME_NAME,
        "Bump'n'Jump",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Kevin Brisley",

    ASSIGN_GAME_REQD_FILES,
        "bnj12b.bin",
        "bnj12c.bin",
        "bnj12d.bin",
        "bnj6c.bin",
        "bnj4e.bin",
        "bnj4f.bin",
        "bnj4h.bin",
        "bnj10e.bin",
        "bnj10f.bin",

FOR( bnj, GameBumpNJump )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameBumpNJump
//
//  Description:
//
//      This is the main constructor for a DECO Bump'n'Jump game object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameBumpNJump::GameBumpNJump(
    const KString& iName
)
:
    GameBumpNJumpBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameBumpNJump
//
//  Description:
//
//      This is the destructor for the DECO Bump'n'Jump game object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameBumpNJump::~GameBumpNJump(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the DECO Bump'n'Jump game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameBumpNJump::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameBumpNJump" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Bump'n'Jump.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameBumpNJump::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0a000, m_pGameInfo->getGameId( ), "bnj12b.bin" );
    m_pSpaceGame->loadFile( 0x0c000, m_pGameInfo->getGameId( ), "bnj12c.bin" );
    m_pSpaceGame->loadFile( 0x0e000, m_pGameInfo->getGameId( ), "bnj12d.bin" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0f000, m_pGameInfo->getGameId( ), "bnj6c.bin" );
    
    //  Load in the foreground graphic ROMs.
    m_pBufferFG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "bnj4e.bin" );
    m_pBufferFG->loadFile( 0x2000, m_pGameInfo->getGameId( ), "bnj4f.bin" );
    m_pBufferFG->loadFile( 0x4000, m_pGameInfo->getGameId( ), "bnj4h.bin" );

    //  Load in the background graphic ROMs.
    m_pBufferBG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "bnj10e.bin" );
    m_pBufferBG->loadFile( 0x1000, m_pGameInfo->getGameId( ), "bnj10f.bin" );

    //  Decrypt the game ROMs.
    decryptROMs( );
}
