///////////////////////////////////////////////////////////////////////////////
//
//  File:       lnc.h
//
//  Class:      GameLockNChase - Concrete
//  
//  Hierarchy:  GameLockNChase - GameDataEastIGS - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the class for the Lock'N'Chase driver.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _lnc_h_
#define _lnc_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "_decoigs.h"



///////////////////////////////////////////////////////////////////////////////
//  GameLockNChase Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameLockNChase : public GameDataEastIGS
{
    public:

        //  Creation/Deletion.
                 GameLockNChase ( const KString& iName );
        virtual ~GameLockNChase ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
   
        //  Interface.
        virtual void  updateDisplay          ( 
            Bitmap* pScreen, Bitmap* pTempScreen 
        );

    protected:

        //  Local Startup functions.
        virtual void startUpSpace    ( );
        virtual void startUpROMs     ( );
        virtual void startUpInput    ( );
        virtual void startUpGraphics ( );
        virtual void startUpColour   ( );
        virtual void startUpMemMap   ( );

        //  Non-default memory handlers.
        static void s_writeVideoRAM     (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeScreenRotate (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );


        //  Member Data.
        Byte*   m_pbCharSetRAM;
        Buffer* m_pDirty;

    private:

};

#endif
