///////////////////////////////////////////////////////////////////////////////
//
//  File:       robocop.h
//
//  Class:      GameRobocop - Concrete
//  
//  Hierarchy:  GameRobocop - GameRobocopBase - GameDataEast0 - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the game class for Data East's Robocop.  This supports the
//      original board.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _robocop_h_
#define _robocop_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "_robocop.h"


///////////////////////////////////////////////////////////////////////////////
//  GameRobocop Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameRobocop : public GameRobocopBase
{
    public:

        //  Creation/Deletion.
                 GameRobocop ( const KString& iName );
        virtual ~GameRobocop ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
   
    protected:

        //  Local Startup functions.
        virtual void startUpROMs     ( );
        virtual void startUpMemMap   ( );

        //  Non-default memory handlers.
        static DWord s_readASIC         (
            DWord dwAddress, ReadHandler* pHandler 
        );
        static void s_writeASIC         (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );

        //  Member Data.
        Byte m_abASIC[ 16 ];

    private:

};

#endif
