///////////////////////////////////////////////////////////////////////////////
//
//  File:    robocopp.cpp
//
//  Class:   GameRobocopPirate
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game class for Data East's Robocop.  This supports a
//      pirate board without the mystery ASIC.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.

//  Application Headers.
#include "robocopp.h"
#include "gameinfo.h"
#include "space.h"
#include "buffer.h"



///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "robocopp",

    ASSIGN_GAME_NAME,
        "Robocop (Pirate)",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Kevin Brisley",

    ASSIGN_GAME_REQD_FILES,
        "robop_00.rom",
        "robop_01.rom",
        "robop_02.rom",
        "robop_03.rom",
        "robop_04.rom",
        "robop_05.rom",
        "robop_06.rom",
        "robop_07.rom",
        "robop_08.rom",
        "robop_09.rom",
        "robop_10.rom",
        "robop_11.rom",
        "robop_12.rom",
        "robop_13.rom",
        "robop_14.rom",
        "robop_15.rom",
        "robop_16.rom",
        "robop_17.rom",
        "robop_18.rom",
        "robop_19.rom",
        "robop_20.rom",
        "robop_21.rom",
        "robop_22.rom",
        "robop_23.rom",

FOR( robocopp, GameRobocopPirate )


///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameRobocopPirate
//
//  Description:
//
//      This is the main constructor for a Robocop game object.
//      
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameRobocopPirate::GameRobocopPirate(
    const KString& iName
)
:
    GameRobocopBase    ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameRobocopPirate
//
//  Description:
//
//      This is the destructor for a Robocop game object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameRobocopPirate::~GameRobocopPirate(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Robocop game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameRobocopPirate::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameRobocopPirate" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of the Robocop hardware.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameRobocopPirate::startUpROMs(
)
{
    //  Load in the Game ROMs.  The odd & even bytes are split up so we 
    //  load skipping every other byte.
    m_pSpaceGame->loadFileSkip( 0x000000, GAME_ID( ), "robop_05.rom" );
    m_pSpaceGame->loadFileSkip( 0x000001, GAME_ID( ), "robop_01.rom" );
    m_pSpaceGame->loadFileSkip( 0x020000, GAME_ID( ), "robop_04.rom" );
    m_pSpaceGame->loadFileSkip( 0x020001, GAME_ID( ), "robop_00.rom" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x8000, GAME_ID( ), "robop_03.rom" );

    //  Load in the ROMs for the character set.
    m_pBufferChar->loadFile( 0x00000, GAME_ID( ), "robop_22.rom" );
    m_pBufferChar->loadFile( 0x10000, GAME_ID( ), "robop_23.rom" );

    //  Load in the ROMs for the first tile set.
    m_pBufferTile1->loadFile( 0x00000, GAME_ID( ), "robop_18.rom" );
    m_pBufferTile1->loadFile( 0x10000, GAME_ID( ), "robop_19.rom" );
    m_pBufferTile1->loadFile( 0x20000, GAME_ID( ), "robop_20.rom" );
    m_pBufferTile1->loadFile( 0x30000, GAME_ID( ), "robop_21.rom" );

    //  Load in the ROMs for the second tile set.
    m_pBufferTile2->loadFile( 0x00000, GAME_ID( ), "robop_14.rom" );
    m_pBufferTile2->loadFile( 0x08000, GAME_ID( ), "robop_15.rom" );
    m_pBufferTile2->loadFile( 0x10000, GAME_ID( ), "robop_16.rom" );
    m_pBufferTile2->loadFile( 0x18000, GAME_ID( ), "robop_17.rom" );

    //  Load in the ROMs for the sprite set.
    m_pBufferSprite->loadFile( 0x00000, GAME_ID( ), "robop_07.rom" );
    m_pBufferSprite->loadFile( 0x10000, GAME_ID( ), "robop_06.rom" );
    m_pBufferSprite->loadFile( 0x18000, GAME_ID( ), "robop_09.rom" );
    m_pBufferSprite->loadFile( 0x28000, GAME_ID( ), "robop_08.rom" );
    m_pBufferSprite->loadFile( 0x30000, GAME_ID( ), "robop_11.rom" );
    m_pBufferSprite->loadFile( 0x40000, GAME_ID( ), "robop_10.rom" );
    m_pBufferSprite->loadFile( 0x48000, GAME_ID( ), "robop_13.rom" );
    m_pBufferSprite->loadFile( 0x58000, GAME_ID( ), "robop_12.rom" );
}
