///////////////////////////////////////////////////////////////////////////////
//
//  File:    superpac.cpp
//
//  Class:   GameSuperPacMan
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for Bally Midway's, Super Pac-Man.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "superpac.h"
#include "gameinfo.h"
#include "space.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "superpac",

    ASSIGN_GAME_NAME,
        "Super Pac-Man (Bally)",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Kevin Brisley",
        "Lawnmower Man (sprites)",

    ASSIGN_GAME_REQD_FILES,
        "spc-2.1c",
        "spc-1.1b",
        "spv-1.3c",
        "spv-2.3f",
        "spc-3.1k",

FOR( superpac, GameSuperPacMan )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameSuperPacMan
//
//  Description:
//
//      This is the main constructor for Super Pac-Man.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameSuperPacMan::GameSuperPacMan(
    const KString& iName
)
:
    GameSuperPacManBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameSuperPacMan
//
//  Description:
//
//      This is the destructor for Super Pac-Man.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameSuperPacMan::~GameSuperPacMan(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Super Pac-Man game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameSuperPacMan::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameSuperPacMan" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Super Pac-Man.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameSuperPacMan::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0xc000, m_pGameInfo->getGameId( ), "spc-2.1c" );
    m_pSpaceGame->loadFile( 0xe000, m_pGameInfo->getGameId( ), "spc-1.1b" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0xf000, m_pGameInfo->getGameId( ), "spc-3.1k" );
    
    //  Load in the graphic ROMs.
    m_pBufferChar->loadFile( 0x0000, m_pGameInfo->getGameId( ), "spv-1.3c" );
    m_pBufferSprite->loadFile( 0x0000, m_pGameInfo->getGameId( ), "spv-2.3f" );
}
