///////////////////////////////////////////////////////////////////////////////
//
//  File:       bitmapl.h
//
//  Class:      BitmapLinux - Concrete
//  
//  Hierarchy:  BimtapLinux - BitmapUniX - Bitmap - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a bitmap that can be displayed on the screen
//      for the Linux platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _bitmapl_h_
#define _bitmapl_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "bitmapx.h"


///////////////////////////////////////////////////////////////////////////////
//  BitmapLinux Class Definition
///////////////////////////////////////////////////////////////////////////////
class BitmapLinux : public BitmapUnixX
{
    public:

        //  Build Method.
        static BitmapLinux* s_build( 
            const KString& iName, 
            const DWord    dwWidth, 
            const DWord    dwHeight, 
            const Byte     bScreen  = FALSE,
            const Byte     bScale   = 0,
            Display*       pDisplay = NULL,
            Screen*        pScreen  = NULL,
            XVisualInfo*   pVisual  = NULL
        );

        //  Deletion.
        virtual ~BitmapLinux ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Blit Interface.
        virtual void blit (
            Bitmap* pSrc,
            DWord   dwItem,
            DWord*  pdwColourTable
        );
        virtual void blit ( 
            Bitmap*      pSrc,
            int32        nOX,
            int32        nOY,
            DWord*       pdwColourTable,
            Byte         bFlipX,
            Byte         bFlipY,
            Clipping*    pClipping,
            Transparency eTransparency,
            Byte         bTransparentColour = 0x00
        );
        virtual void blitScrollFull ( 
            Bitmap*      pSrc,
            int32        nScrollX,
            int32        nScrollY,
            Clipping*    pClipping,
            Transparency eTransparency,
            Byte         bTransparentColour = 0x00
        );

    protected:

        //  Creation is protected since a build method should be used.
        BitmapLinux ( 
            const KString& iName, 
            const DWord    dwWidth, 
            const DWord    dwHeight, 
            const Byte     bScreen  = FALSE,
            const Byte     bScale   = 0,
            Display*       pDisplay = NULL,
            Screen*        pScreen  = NULL,
            XVisualInfo*   pVisual  = NULL
        );

        //  A helper function for performing the scrolling blit.
        void blitScrollFullGo (
            int32        nDestX,
            int32        nDestY,
            Transparency eTransparency
        );

    private:

};

#endif
