///////////////////////////////////////////////////////////////////////////////
//
//  File:       canvasl.h
//
//  Class:      CanvasLinux - Concrete
//  
//  Hierarchy:  CanvasLinux - CanvasUnixX - Canvas - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents the Display of the Replay application on
//      the Linux platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _canvasl_h_
#define _canvasl_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "canvasx.h"

//  Forward class declarations.
class Bitmap;

///////////////////////////////////////////////////////////////////////////////
//  CanvasLinux Class Definition
///////////////////////////////////////////////////////////////////////////////
class CanvasLinux : public CanvasUnixX
{
    public:

        //  Build method.
        static CanvasLinux* s_build( const KString& iName );

        //  Deletion.
        virtual ~CanvasLinux ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Bitmap Interface.
        virtual Bitmap*   createBitmap ( 
            const KString& iName,
            DWord          dwWidth,
            DWord          dwHeight,
            Byte           bForScreen = FALSE
        );
    protected:

        //  Creation/Initialization.
        CanvasLinux ( const KString& iName );
        
    private:

};


#endif
