///////////////////////////////////////////////////////////////////////////////
//
//  File:    configl.cpp
//
//  Class:   ConfigurationLinux
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for Configuration
//      duties in a Linux Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "configl.h"


///////////////////////////////////////////////////////////////////////////////
//  File Static Variables.
///////////////////////////////////////////////////////////////////////////////

//  The singleton instance.
ConfigurationLinux ConfigurationLinux::sm_configurationLinux( "Configuration" );


///////////////////////////////////////////////////////////////////////////////
//
//  Function: ConfigurationLinux
//
//  Description:
//
//      This is the main constructor for the Linux Unix/X configuration 
//      object.  It is protected because it is a singleton and therefore 
//      cannot be instantiated by anyone but itself or a derived class.
//
//  Parameters:
//
//      iName (input)
//          The name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ConfigurationLinux::ConfigurationLinux(
    const KString& iName
)
:
    ConfigurationUnixX ( iName )
{
    //  Add the parameters that are used in Linux.
    addParam( "-numfrags", "<num>",  "Number of fragments in sound driver." );
    addParam( "-fragsize", "<size>", "Size of each sound driver fragment." );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~ConfigurationLinux
//
//  Description:
//
//      This is the destructor for the Linux Unix/X configuration object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ConfigurationLinux::~ConfigurationLinux(
)
{
    //  Nothing to do.
}




///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the configuration object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
ConfigurationLinux::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "ConfigurationLinux" );

    return( className );
}
