///////////////////////////////////////////////////////////////////////////////
//
//  File:       joyl.h
//
//  Class:      JoystickLinux - Concrete
//  
//  Hierarchy:  JoystickLinux - Joystick - 
//                  DigitalController - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The JoystickLinux class encapsulates joystick access for the Linux
//      platform using the kernel joystick module.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _joyl_h_
#define _joyl_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <linux/joystick.h>

//  Application Headers.
#include "joy.h"


///////////////////////////////////////////////////////////////////////////////
//  JoystickLinux Class Definition
///////////////////////////////////////////////////////////////////////////////
class JoystickLinux : public Joystick
{
    public:

        //  Build method.
        static JoystickLinux* s_build( const KString& iName );

        //  Deletion.
        virtual ~JoystickLinux ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
        virtual Byte           update       ( );

    protected:

        //  Creation is protected.  Clients should use a build method.
        JoystickLinux ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );


        //  Member Data.
        int32        m_nJoy0FD;
        int32        m_nJoy1FD;
        JS_DATA_TYPE m_origValues0;
        JS_DATA_TYPE m_origValues1;

        //  Static Member Data.
        static const int32 sm_nThreshold;

    private:

};

#endif
